<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>
<?php
$this->assign('title', __('Create an Account'));
$this->assign('description', __('Register a new membership'));
?>
<div class="mb-5">
<a class="text-primary" href="/">
<h4 class="font-weight-light"><?= h(get_option('site_name')) ?></h4>
</a>
</div>

<div>
<h4>Create an Account</h4>
<h6 class="font-weight-light">Register a new membership</h6>
<?= $this->Flash->render() ?>
<!-- /! -->

<?= $this->Form->create($user, ['id' => 'signup-form']); ?>

<div class="form-group text  required">
    <?=
$this->Form->control('username', [
    'label' => false,
    'placeholder' => __('Username'),
    'class' => 'form-control form-control-lg',
    'style' => 'color: #1c1e2f'
])
?>
   
    <span class="help-block"></span></div>
<div class="form-group email  required">
    <?=
$this->Form->control('email', [
    'label' => false,
    'placeholder' => __('Email'),
    'class' => 'form-control form-control-lg',
    'style' => 'color: #1c1e2f'
])
?>
   
    <span class="help-block"></span></div>
<div class="form-group password  required">

<?=
$this->Form->control('password', [
    'label' => false,
    'placeholder' => __('Password'),
    'class' => 'form-control form-control-lg',
    'style' => 'color: #1c1e2f'
])
?>
    <span class="help-block"></span></div>
<div class="form-group password  required">
    <?=
$this->Form->control('password_compare', [
    'type' => 'password',
    'label' => false,
    'placeholder' => __('Re-enter Password'),
    'class' => 'form-control form-control-lg',
    'style' => 'color: #1c1e2f'
])
?>
    <span class="help-block"></span></div>
<?php if ((get_option('enable_captcha_signup') == 'yes') && isset_captcha()) : ?>
    <div class="form-group captcha">
        <div id="captchaSignup" style="display: inline-block;"></div>
    </div>
<?php endif; ?>

<div class="form-group">
    <?= $this->Form->control('accept', [
        'type' => 'checkbox',
        'label' => "<b>" . __(
                "I agree to the {0} and {1}.",
                "<a href='" . $this->Url->build('/') . 'pages/terms' . "' target='_blank'>" .
                __('Terms of Use') . "</a>",
                "<a href='" . $this->Url->build('/') . 'pages/privacy' . "' target='_blank'>" .
                __('Privacy Policy') . "</a>"
            ) . "</b>",
        'escape' => false
    ]) ?>
</div>

<?= $this->Form->button(__('Register'), [
    'class' => 'btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn btn-captcha',
    'id' => 'invisibleCaptchaSignup'
]); ?>

<?= $this->Form->end() ?>


<div class="social-auth-links text-center">
<br> <p>- OR -</p>
  <?php if ((bool)get_option('social_login_facebook', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-facebook"></i> ' . __("Log in with Facebook"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'facebook',
                '?' => ['redirect' => $this->request->getQuery('redirect')]
            ],
            [
                'class' => 'btn btn-block btn-social btn-facebook',
                'style' => 'margin-bottom: 5px;',
                'escape' => false
            ]
        );
        ?>
    <?php endif; ?>

    <?php if ((bool)get_option('social_login_twitter', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-twitter"></i> ' . __("Log in with Twitter"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'twitter',
                '?' => ['redirect' => $this->request->getQuery('redirect')]
            ],
            [
                'class' => 'btn btn-block btn-social btn-twitter',
                'style' => 'margin-bottom: 5px;',
                'escape' => false
            ]
        );
        ?>
    <?php endif; ?>

    <?php if ((bool)get_option('social_login_google', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-google"></i> ' . __("Log in with Google"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'google',
                '?' => ['redirect' => $this->request->getQuery('redirect')]
            ],
            [
                'class' => 'btn btn-block btn-social btn-google',
                'style' => 'margin-bottom: 5px;',
                'escape' => false
            ]
        );
        ?>
    <?php endif; ?>
</div>
<div class="mt-4 font-weight-light">
<div class="text-center mt-4 font-weight-light">
I already have a <a href="/auth/signin" class="text-primary">membership</a>
</div>
</div> </div>
</div>
</div>