<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>
<?php
$this->assign('title', __('Sign In'));
$this->assign('description', __('Sign in to start your session'));
?>
  
<div class="mb-5">
<a class="text-primary" href="/">
<h4 class="font-weight-light"><a href="<?php echo $this->Url->build('/'); ?>"><?= h(get_option('site_name')) ?></a></h4>
</a>
</div>

<div>
<h4>Welcome back!</h4>
<br>
<h6 class="font-weight-light">Happy to see you again!</h6>
<br>
<?= $this->Flash->render() ?>
<?= $this->Form->create($user, ['id' => 'signin-form']); ?>
<div class="form-group text  required">
<?=
$this->Form->control('username', [
    'label' => __('Username / Email Address'),
    'placeholder' => __('Username or email address'),
    'class' => 'form-control form-control-lg',
     'style' => 'color: #1c1e2f',
])
?><span class="help-block"></span></div>
<div class="form-group password  required"><?=
$this->Form->control('password', [
    'label' => __('Password'),
    'placeholder' => __('Password'),
    'class' => 'form-control form-control-lg',
    'style' => 'color: #1c1e2f',
])
?><span class="help-block"></span></div>
<?php if ((get_option('enable_captcha_signin', 'no') == 'yes') && isset_captcha()) : ?>
    <div class="form-group captcha">
<div id="captchaSignin" style="display: inline-block;"></div>
</div>
<?php endif; ?>
<div class="mt-3">
<?= $this->Form->button(__('Login'), [
    'class' => 'btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn btn-captcha',
    'id' => 'invisibleCaptchaSignin',
]); ?></div>
<div class="my-2 d-flex justify-content-between align-items-center">
<div class="form-check">

<?= $this->Form->control('remember_me', [
    'type' => 'checkbox',
    'label' => __('Remember me'),
]) ?>
</div>
<?= $this->Form->end() ?>
<a class="auth-link text-black" href="/auth/forgot-password">Forgot password?</a>
</div>

<div class="social-auth-links text-center">
<p>- OR -</p>
 <?php if ((bool)get_option('social_login_facebook', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-facebook"></i> ' . __("Log in with Facebook"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'facebook',
                '?' => ['redirect' => $this->request->getQuery('redirect')],
            ],
            [
                'class' => 'btn btn-block btn-social btn-facebook',
                'style' => 'margin-bottom: 5px;',
                'escape' => false,
            ]
        );
        ?>
    <?php endif; ?>

    <?php if ((bool)get_option('social_login_twitter', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-twitter"></i> ' . __("Log in with Twitter"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'twitter',
                '?' => ['redirect' => $this->request->getQuery('redirect')],
            ],
            [
                'class' => 'btn btn-block btn-social btn-twitter',
                'style' => 'margin-bottom: 5px;',
                'escape' => false,
            ]
        );
        ?>
    <?php endif; ?>

    <?php if ((bool)get_option('social_login_google', false)) : ?>
        <?php
        echo $this->Form->postLink(
            '<i class="fa fa-google"></i> ' . __("Log in with Google"),
            [
                'prefix' => false,
                'plugin' => 'ADmad/SocialAuth',
                'controller' => 'Auth',
                'action' => 'login',
                'provider' => 'google',
                '?' => ['redirect' => $this->request->getQuery('redirect')],
            ],
            [
                'class' => 'btn btn-block btn-social btn-google',
                'style' => 'margin-bottom: 5px;',
                'escape' => false,
            ]
        );
        ?>
    <?php endif; ?> </div>
<br>
<div class="text-center mt-4 font-weight-light">
Dont have an account? <a href="/auth/signup" class="text-primary">Create</a>
</div>
</div>
</div>
</div>
<div class="col-lg-6 login-half-bg d-flex flex-row">
<div class="info-holder">
<img src="https://hidelinks.in/dashboard/images/auth/login-bg-2.svg" alt="" /> </div>
<p class="text-white font-weight-medium text-center flex-grow align-self-end">
Copyright <?= __('&copy;') ?> <?= date("Y") ?> <?= h(get_option('site_name')) ?></p>
</div>
</div>
</div>

</div>

</div>

<footer>
<div class="container text-center">
</div>
</footer>
<?php $this->start('scriptBottom'); ?>

<script>
  var url_href = window.location.href;
  if (url_href.substr(-1) === '#') {
    history.pushState('', document.title, url_href.substr(0, url_href.length - 1));
  }
</script>

<?php $this->end(); ?>
