<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
$this->assign('title', __('Forgot Password'));
$this->assign('description', __('Enter your e-mail address below to reset your password.'));
?>

<div class="mb-5">
<a class="text-primary" href="/">
<h4 class="font-weight-light"><?= h(get_option('site_name')) ?></h4>
</a>
</div>

<div>
<h4>Forget Password</h4>
<h6 class="font-weight-light">Enter your e-mail address below to reset your password.</h6>
<?= $this->Flash->render() ?>
<!-- /! -->

<?php if (!isset($user->id)) { ?>
    <?= $this->Form->create($user, ['id' => 'forgotpassword-form']); ?>
  
<div class="form-group email  required">
      <?=
    $this->Form->control('email', [
        'label' => false,
        'placeholder' => __('Email'),
        'class' => 'form-control form-control-lg',
        'type' => 'email',
        'style' => 'color: #1c1e2f'
    ])
    ?>
<span class="help-block"></span></div>
   <?php if ((get_option('enable_captcha_forgot_password') == 'yes') && isset_captcha()) : ?>
        <div class="form-group captcha">
            <div id="captchaForgotpassword" style="display: inline-block;"></div>
        </div>
    <?php endif; ?>

    <?= $this->Form->button(__('Send request'), [
        'class' => 'btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn btn-captcha',
        'id' => 'invisibleCaptchaForgotpassword'
    ]); ?>
    <?= $this->Form->end() ?>

<?php } else { ?>

    <?= $this->Form->create($user); ?>

    <?= $this->Form->hidden('id', ['value' => $user->id]); ?>

    <?=
    $this->Form->control('password', [
        'label' => false,
        'placeholder' => __('New Password'),
        'class' => 'form-control',
        'type' => 'password'
    ])
    ?>

    <?=
    $this->Form->control('confirm_password', [
        'label' => __('Re-enter New Password'),
        'label' => false,
        'placeholder' => __('Re-enter New Password'),
        'class' => 'form-control',
        'type' => 'password'
    ])
    ?>

    <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn btn-captcha']); ?>

    <?= $this->Form->end() ?>
<?php } ?> <div style="display:none;"><input type="hidden" name="_Token[fields]" autocomplete="off" value="0a938c30888e3b1d02645e5190ccb99080c54800%3A" /><input type="hidden" name="_Token[unlocked]" autocomplete="off" value="adcopy_challenge%7Cadcopy_response%7Ccaptcha_code%7Ccaptcha_namespace%7Cg-recaptcha-response" /></div></form>
<div class="text-center mt-4">
<div class="mt-2 font-weight-light">
Create an <a href="/auth/signup" class="text-primary">account</a>
</div>
<div class="mt-2 font-weight-light">
I already have a <a href="/auth/signin" class="text-primary">membership</a>
</div>
</div> </div>
</div>
</div>