<?php
/**
 * @var \App\View\AppView $this
 */
?>
<!DOCTYPE html>
<html lang="<?= locale_get_primary_language(null) ?>">
<head>
    <meta name="robots" content="noindex, nofollow">
    <meta name="og:title" content="<?= h($this->fetch('og_title')); ?>">
    <meta name="og:description" content="<?= h($this->fetch('og_description')); ?>">
    <meta property="og:image" content="<?= h($this->fetch('og_image')); ?>"/>
    <?= $this->element('front_head'); ?>
</head>
<body class="banner-page">
<div id="wrapper" class="wrapper clearfix">
<?= get_option('after_body_tag_code'); ?>

<header id="navbar-spy" class="header header-1 header-transparent header-fixed">

<nav id="primary-menu" class="navbar navbar-expand-lg navbar-dark">
<div class="container">
  <?php
            $logo = get_logo();
            $class = '';
            if ($logo['type'] == 'image') {
                $class = 'logo-image';
            }
            ?>
<a class="navbar-brand logo-image" href="<?= build_main_domain_url('/'); ?>"><?= $logo['content'] ?></a>

<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
<span class="toogle-inner"></span>
</button>

<div class="collapse navbar-collapse" id="navbarContent">
      <?=
            menu_display('menu_main', [
                'ul_class' => 'navbar-nav ml-auto',
                'li_class' => '',
                'a_class' => '',
            ], true);
            ?>

</div>

</div>

</nav>
</header>

<section id="hero" class="shorten section hero">
<div class="container">
<div class="row">
<div class="col-12 col-sm-12 col-md-11 col-lg-12">


            <?= $this->fetch('content') ?>
      </div>
    </div>
</div>


<?= $this->element('front_footer'); ?>

</body>
</html>
